﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Mouse.Sample1
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern bool ClipCursor(ref Rectangle lpRect);

        [DllImport("user32.dll")]
        public static extern bool GetClipCursor(out Rectangle lpRect);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonClipCursor_Click(object sender, EventArgs e)
        {
            Rectangle lpRect = new Rectangle(this.Left, this.Top, this.Right, this.Bottom);
            ClipCursor(ref lpRect);
        }

        private void buttonGetClipCursor_Click(object sender, EventArgs e)
        {
            Rectangle lpRect = new Rectangle();
            if (GetClipCursor(out lpRect))
            {
                MessageBox.Show(String.Format("Mouse Area = > Top = {0} , Left = {1} , Right = {2} , Bottom = {3}", lpRect.Top, lpRect.Left, lpRect.Right, lpRect.Bottom));
            }
        }
    }
}